* Loading data from Excel spreadsheets
* Define path
*global path "C:/Users/eilya/Principal Economics/PE - NZTA - RLTDM/Stata"
*global path "C:/Users/eilya/Principal Economics/PE - Stata/MS1/Input"

*Preliminaries
cd "${Dir}/${InputDir}"

** Population data
mata
b= xl()
b.load_book("Population_data.xlsx")

/*LATR_f*/
sheets = b.set_sheet("LATR_f")
LATR_f=b.get_number((2,650),(3,103)) 

/*LATR_m*/
sheets = b.set_sheet("LATR_m")
LATR_m=b.get_number((2,650),(3,103))

/*pop_hist_f*/
sheets = b.set_sheet("pop_hist_f")
pop_hist_f=b.get_number((3,31),(2,102))

/*pop_hist_m*/
sheets = b.set_sheet("pop_hist_m")
pop_hist_m=b.get_number((3,31),(2,102))

/*multif_onep*/
sheets = b.set_sheet("multif_onep")
multif_onep=b.get_number((2,60),2)

/*multif_twop*/
sheets = b.set_sheet("multif_twop")
multif_twop=b.get_number((2,60),2)

/*mortality_f*/
sheets = b.set_sheet("mortality_f")
mortality_f=b.get_number((3,41),(2,102))

/*mortality_m*/
sheets = b.set_sheet("mortality_m")
mortality_m=b.get_number((3,41),(2,102))

/*fertility_rate*/
sheets = b.set_sheet("fertility_rate")
fertility_rate=b.get_number((3,41),(2,102))

/*netmigration_agedist_f*/
sheets = b.set_sheet("netmigration_agedist_f")
netmigration_agedist_f=b.get_number(3,(1,101))

/*netmigration_agedist_m*/
sheets = b.set_sheet("netmigration_agedist_m")
netmigration_agedist_m=b.get_number(3,(1,101))

/*fam_per_hh*/
sheets = b.set_sheet("fam_per_hh")
fam_per_hh=b.get_number((2,60),2)

/*people_per_multi*/
sheets = b.set_sheet("people_per_multi")
people_per_multi=b.get_number((2,60),2)

/*reg_pop_hist_f*/
sheets = b.set_sheet("reg_pop_hist_f")
reg_pop_hist_f=b.get_number((3,350),(3,103))

/*reg_pop_hist_m*/
sheets = b.set_sheet("reg_pop_hist_m")
reg_pop_hist_m=b.get_number((3,350),(3,103))

/*immigr*/
sheets = b.set_sheet("immigr")
immigr=b.get_number((2,30),2)

/*immigr_age_dist*/
sheets = b.set_sheet("immigr_agedist")
immigr_agedist=b.get_number(3,(2,102))

/*immigr_regdist*/
sheets = b.set_sheet("immigr_regdist")
immigr_regdist=b.get_number((3,14),(2,102))

/*p_emigr*/
sheets = b.set_sheet("p_emigr")
p_emigr=b.get_number((3,103),(2,13))

/*p_emigr_dest*/
sheets = b.set_sheet("p_emigr_dest")
p_emigr_dest=b.get_number((3,1214),(3,15))

/*os_emigr*/
sheets = b.set_sheet("os_emigr")
os_emigr=b.get_number((2,30),(2,102))

/*fert_adj*/
sheets = b.set_sheet("fert_adj")
fert_adj=b.get_number((3,14),(2,102))

/** Growth data**/
/*Preliminaries*/
b.load_book("Economic_growth_data.xlsx")

/*reg_ind_shr_data*/
sheets = b.set_sheet("reg_ind_shr_data")
reg_ind_shr_data=b.get_number((3,194),(3,31))

/*gdp_ind_vol_shr*/
sheets = b.set_sheet("gdp_ind_vol_shr")
gdp_ind_vol_shr=b.get_number((2,30),(2,18))

/*ind_vol_shr_coeffs*/
sheets = b.set_sheet("ind_vol_shr_coeffs")
ind_vol_shr_coeffs=b.get_number((2,18),(2,17))

/*gdp_ind_nom*/
sheets = b.set_sheet("gdp_ind_nom")
gdp_ind_nom=b.get_number((2,30),(2,18))

/*gdp_ind_vol*/
sheets = b.set_sheet("gdp_ind_vol")
gdp_ind_vol=b.get_number((2,30),(2,18))

/*gdp_ind_nom_shr*/
sheets = b.set_sheet("gdp_ind_nom_shr")
gdp_ind_nom_shr=b.get_number((2,30),(2,18))

/*gdp_vol*/
sheets = b.set_sheet("gdp_vol")
gdp_vol=b.get_number((2,30),2)

/*gdp_nom*/
sheets = b.set_sheet("gdp_nom")
gdp_nom=b.get_number((2,30),2)

/*lbr_inc_shr*/
sheets = b.set_sheet("lbr_inc_shr")
lbr_inc_shr=b.get_number((2,30),2)

/*k_inc_shr*/
sheets = b.set_sheet("k_inc_shr")
k_inc_shr=b.get_number((2,30),2)

/*k_input*/
sheets = b.set_sheet("k_input")
k_input=b.get_number((2,30),2)

/*l_input*/
sheets = b.set_sheet("l_input")
l_input=b.get_number((2,30),2)

/*mfp_index*/
sheets = b.set_sheet("mfp_index")
mfp_index=b.get_number((2,30),2)

/*hh_inc_input*/
sheets = b.set_sheet("hh_inc_input")
hh_inc_input=b.get_number((2,24),(2,7))

/*reg_hh_inc_input*/
sheets = b.set_sheet("reg_hh_inc_input")
reg_hh_inc_input=b.get_number((2,139),(3,14))

/*ind_mfp_index*/
sheets = b.set_sheet("ind_mfp_index")
ind_mfp_index=b.get_number((2,30),(2,17))

/*reg_emp_shr_data*/
sheets = b.set_sheet("reg_emp_shr_data")
reg_emp_shr_data=b.get_number((3,194),(3,31))

/*emp_by_ind*/
sheets = b.set_sheet("emp_by_ind")
emp_by_ind_nzl=b.get_number((2,22),(2,17))

/** Labour force data **/
/*Preliminaries*/
b.load_book("Labour_force_data.xlsx")

/*reg_lfpr_input*/
sheets = b.set_sheet("reg_lfpr_input")
reg_lfpr_input=b.get_number((2,30),(2,13))

/*reg_unemp_input*/
sheets = b.set_sheet("reg_unemp_input")
reg_unemp_input=b.get_number((2,30),(2,13))

/*lfpr_f*/
sheets = b.set_sheet("lfpr_f")
lfpr_f=b.get_number((2,30),(2,12))

/*lfpr_m*/
sheets = b.set_sheet("lfpr_m")
lfpr_m=b.get_number((2,30),(2,12))

/*unemployment_rate*/
sheets = b.set_sheet("unemployment_rate")
unemployment_rate=b.get_number((2,30),2)

end


/** Fleet data**/
mata
/*Preliminaries*/
b.load_book("VKT_data.xlsx")

/*vkt_input*/
sheets = b.set_sheet("vkt_input")
vkt_input=b.get_number((3,1102),(3,47))

/*eff_input*/
sheets = b.set_sheet("eff_input")
eff_input=b.get_number((3,1157),(3,47))

/*ruc_rate_input*/
sheets = b.set_sheet("ruc_rate_input")
ruc_rate_input=b.get_number((2,1156),(3,47))
end

/** Price data **/
mata
/*Preliminaries*/
b.load_book("Price_data.xlsx")

/*cpi*/
sheets = b.set_sheet("cpi")
cpi=b.get_number((2,30),2)

/*diesel_base_price*/
sheets = b.set_sheet("diesel_base_price")
diesel_base_price=b.get_number((2,30),2)

/*diesel_ets_cost*/
sheets = b.set_sheet("diesel_ets_cost")
diesel_ets_cost=b.get_number((2,30),2)

/*diesel_imp_margin*/
sheets = b.set_sheet("diesel_imp_margin")
diesel_imp_margin=b.get_number((2,30),2)

/*diesel_pump_price*/
sheets = b.set_sheet("diesel_pump_price")
diesel_pump_price=b.get_number((2,30),2)

/*diesel_taxes*/
sheets = b.set_sheet("diesel_taxes")
diesel_taxes=b.get_number((2,30),2)

/*fuel_price_cpi*/
sheets = b.set_sheet("fuel_price_cpi")
fuel_price_cpi=b.get_number((2,30),2)

/*gst*/
sheets = b.set_sheet("gst")
gst=b.get_number((2,30),2)

/*nz_usd_er*/
sheets = b.set_sheet("nz_usd_er")
nz_usd_er=b.get_number((2,30),2)

/*oil_price_usd*/
sheets = b.set_sheet("oil_price_usd")
oil_price_usd=b.get_number((2,30),2)

/*petrol_base_price*/
sheets = b.set_sheet("petrol_base_price")
petrol_base_price=b.get_number((2,30),2)

/*petrol_ets_cost*/
sheets = b.set_sheet("petrol_ets_cost")
petrol_ets_cost=b.get_number((2,30),2)

/*petrol_imp_margin*/
sheets = b.set_sheet("petrol_imp_margin")
petrol_imp_margin=b.get_number((2,30),2)

/*petrol_pump_price*/
sheets = b.set_sheet("petrol_pump_price")
petrol_pump_price=b.get_number((2,30),2)

/*petrol_taxes*/
sheets = b.set_sheet("petrol_taxes")
petrol_taxes=b.get_number((2,30),2)

/*vehicle_price*/
sheets = b.set_sheet("vehicle_price")
vehicle_price=b.get_number((2,30),2)

/*vehicle_price_new*/
sheets = b.set_sheet("vehicle_price_new")
vehicle_price_new=b.get_number((2,30),2)


/*vehicle_price_used*/
sheets = b.set_sheet("vehicle_price_used")
vehicle_price_used=b.get_number((2,30),2)


/*fuel excise duty revenue*/
sheets = b.set_sheet("fed")
fed=b.get_number((2,30),2)

/*total ruc revenue*/
sheets = b.set_sheet("ruc")
ruc=b.get_number((2,30),2)


/*registration revenue*/
sheets = b.set_sheet("rego")
rego=b.get_number((2,30),2)


/*licensing revenue incl change of ownership*/
sheets = b.set_sheet("licen")
licen=b.get_number((2,30),2)

/*total nltf revenue excl refunds*/
sheets = b.set_sheet("nltf")
nltf=b.get_number((2,30),2)

/********************/
/*NZTA pt farebox subsidies (excludes SCG) THE DATA IS ACTUAL UNTIL 2015*/ 
sheets = b.set_sheet("nzta_subsidy")
nzta_subsidy=b.get_number((2,21),(2,13))

/*Local govt pt farebox subsidies (excludes SCG) THE DATA IS ACTUAL UNTIL 2015*/
sheets = b.set_sheet("lg_subsidy")
lg_subsidy=b.get_number((2,21),(2,13))

end

/** Fleet data*/
/*Preliminaries*/
mata
b.load_book("Fleet_data.xlsx")

/*bus_input*/
sheets = b.set_sheet("bus_input")
bus_input=b.get_number((2,190),(3,47))

/*bus_reg_input*/
sheets = b.set_sheet("bus_reg_input")
bus_reg_input=b.get_number((2,190),(3,47))

/*lpv_input*/
sheets = b.set_sheet("lpv_input")
lpv_input=b.get_number((2,274),(3,47))

/*lpv_reg_input*/
sheets = b.set_sheet("lpv_reg_input")
lpv_reg_input=b.get_number((2,274),(3,47))

/*lcv_input*/
sheets = b.set_sheet("lcv_input")
lcv_input=b.get_number((2,274),(3,47))

/*lcv_reg_input*/
sheets = b.set_sheet("lcv_reg_input")
lcv_reg_input=b.get_number((2,274),(3,47))

/*mc_input*/
sheets = b.set_sheet("mc_input")
mc_input=b.get_number((2,43),(3,47))

/*mc_reg_input*/
sheets = b.set_sheet("mc_reg_input")
mc_reg_input=b.get_number((2,43),(3,47))

/*hcv_input*/
sheets = b.set_sheet("hcv_input")
hcv_input=b.get_number((2,379),(3,47))

/*hcv_reg_input*/
sheets = b.set_sheet("hcv_reg_input")
hcv_reg_input=b.get_number((2,379),(3,47))

/*lpv_size_beta*/
sheets = b.set_sheet("lpv_size_beta")
lpv_size_beta=b.get_number((2,3),2)

/*lcv_size_beta*/
sheets = b.set_sheet("lcv_size_beta")
lcv_size_beta=b.get_number((2,3),2)
end

/** Travel data*/
mata
/*Preliminaries*/
b.load_book("Travel_data.xlsx")

/*pass_age_dist*/
sheets = b.set_sheet("pass_age_dist")
pass_age_dist=b.get_number((2,8),2)

/*pt_age_dist*/
sheets = b.set_sheet("pt_age_dist")
pt_age_dist=b.get_number((2,8),2)

/*vkt_age_dist*/
sheets = b.set_sheet("vkt_age_dist")
vkt_age_dist=b.get_number((2,8),2)

/*reg_km_per_pass_input*/
sheets = b.set_sheet("reg_km_per_pass_input")
reg_km_per_pass_input=b.get_number((2,21),(2,13))

/*reg_occupancy_input*/
sheets = b.set_sheet("reg_occupancy_input")
reg_occupancy_input=b.get_number((2,22),(2,14))

/*reg_pt_passenger_input*/
sheets = b.set_sheet("reg_pt_passenger_input")
reg_pt_passenger_input=b.get_number((2,21),(2,13))

/*reg_pt_passkm_input*/
sheets = b.set_sheet("reg_pt_passkm_input")
reg_pt_passkm_input=b.get_number((2,21),(2,13))

/*reg_vkt_input (distribution relative to mean)*/
sheets = b.set_sheet("reg_vkt_input")
reg_vkt_input=b.get_number((2,22),(2,14))

/*reg_vkt_mot (MOT data on vkt by region - levels)*/
sheets = b.set_sheet("reg_vkt_mot")
reg_vkt_mot=b.get_number((2,21),(2,13))

/*reg_cyc_input*/
sheets = b.set_sheet("reg_cyc_input")
reg_cyc_input=b.get_number((2,21),(2,13))

/*reg_walk_input*/
sheets = b.set_sheet("reg_walk_input")
reg_walk_input=b.get_number((2,21),(2,13))

/*cyc_age_dist*/
sheets = b.set_sheet("cyc_age_dist")
cyc_age_dist=b.get_number((2,8),2)

/*walk_age_dist*/
sheets = b.set_sheet("walk_age_dist")
walk_age_dist=b.get_number((2,8),2)

end


/** VKT data*/
mata
/*Preliminaries*/
b.load_book("VKT_data.xlsx")

/*vkt_input*/
sheets = b.set_sheet("vkt_input")
vkt_input=b.get_number((2,1102),(3,47))

/*eff_input*/
sheets = b.set_sheet("eff_input")
eff_input=b.get_number((2,1157),(3,47))

/*ruc_rate_input*/
sheets = b.set_sheet("ruc_rate_input")
ruc_rate_input=b.get_number((2,1156),(3,47))

/*vkt_tot_input*/
sheets = b.set_sheet("vkt_tot_input")
vkt_tot_input=b.get_number((3,31),3)

end


/** Fleet data used in HH_vehicle_demand.do*/
mata
/*Preliminaries*/
b.load_book("Vehicle_ownership_model_data.xlsx")

/* Area*/
sheets = b.set_sheet("Area")
Area=b.get_number((2,14),2)

/* NZ vehicle ownership probabilities (nz_veh_p)*/
sheets = b.set_sheet("nz_veh_p")
nz_veh_p=b.get_number((3,31),(2,25))

/* Regional vehicle ownership probabilities*/
sheets = b.set_sheet("reg_veh_p")
reg_veh_p=b.get_number((3,350),(3,26))

/* Vehicle model coefficients*/
sheets = b.set_sheet("veh_p_beta")
veh_p_beta=b.get_number((2,31),(2,4))

end

/** Freight data used in Freight demand.do*/
mata
/*Preliminaries*/
b.load_book("Freight_volume_data.xlsx")

/* ind_freight_nom*/
sheets = b.set_sheet("ind_freight_nom")
ind_freight_nom=b.get_number((2,30),(2,10))

/* ind_freight_vol*/
sheets = b.set_sheet("ind_freight_vol")
ind_freight_vol=b.get_number((2,30),(2,10))

/* ind_railfreight_nom*/
sheets = b.set_sheet("ind_railfreight_nom")
ind_railfreight_nom=b.get_number((2,30),(2,10))

/* ind_railfreight_vol*/
sheets = b.set_sheet("ind_railfreight_vol")
ind_railfreight_vol=b.get_number((2,30),(2,10))

/* ind_roadfreight_nom*/
sheets = b.set_sheet("ind_roadfreight_nom")
ind_roadfreight_nom=b.get_number((2,30),(2,10))

/* ind_roadfreight_vol*/
sheets = b.set_sheet("ind_roadfreight_vol")
ind_roadfreight_vol=b.get_number((2,30),(2,10))

/* ind_seafreight_nom*/
sheets = b.set_sheet("ind_seafreight_nom")
ind_seafreight_nom=b.get_number((2,30),(2,10))

/* ind_seafreight_vol*/
sheets = b.set_sheet("ind_seafreight_vol")
ind_seafreight_vol=b.get_number((2,30),(2,10))

/* reg_dist_coeff*/
sheets = b.set_sheet("reg_dist_coeff")
reg_dist_coeff=b.get_number((2,13),(2,9))

/* roadfreight_tkm*/
sheets = b.set_sheet("roadfreight_tkm")
roadfreight_tkm=b.get_number((2,30),2)

/* freight_gdp_corresp*/
sheets = b.set_sheet("freight_gdp_corresp")
freight_gdp_corresp=b.get_number((2,18),(2,10))

/* freight_ind_vol_gdp*/
sheets = b.set_sheet("freight_gdp_ind_vol")
freight_ind_vol_gdp=b.get_number((2,30),(2,10))

/* freight_reg_ind_gdp_shr*/
sheets = b.set_sheet("freight_reg_ind_gdp_shr")
freight_reg_ind_gdp_shr=b.get_number((2,97),(3,31))
end



/** OD data used in Freight demand.do*/
mata
/*Preliminaries*/
b.load_book("freightOD_extradata.xlsx")

/* Area*/
sheets = b.set_sheet("Area")
Area=b.get_number((1,12),1)

/* Ownc*/
sheets = b.set_sheet("Ownc")
Ownc=b.get_number((1,144),1)

/* XVOL_rt*/
sheets = b.set_sheet("XVOL_rt")
XVOL_rt=b.get_number((1,12),(1,23))

end

/** Freight betas data used in Freight demand.do*/
mata
/*Preliminaries*/
b.load_book("freight_betas.xlsx")

/* Dist*/
sheets = b.set_sheet("Dist")
Dist=b.get_number((1,12),(1,12))

/* W_contig*/
sheets = b.set_sheet("W_contig")
W_contig=b.get_number((1,12),(1,12))

/* W_j*/
sheets = b.set_sheet("W_j")
W_config=b.get_number((1,144),(1,144))

/* tkm_beta*/
sheets = b.set_sheet("beta")
tkm_beta=b.get_number((2,14),2)

/* tkm_y*/
sheets = b.set_sheet("y")
tkm_y=b.get_number((2,145),2)
end

/** travel_panel data used in VKT and Cost.do*/
mata
/*Preliminaries*/
b.load_book("travel_panel.xlsx")

/*beta_d*/
sheets = b.set_sheet("beta_d")
beta_d=b.get_number((1,136),1)

/*beta_j*/
sheets = b.set_sheet("beta_j")
beta_j=b.get_number((1,139),1)

/*cost_input_hrt*/
sheets = b.set_sheet("cost_input_hrt")
cost_input_hrt=b.get_number((1,792),1)

/*unemp_input_hrt*/
sheets = b.set_sheet("unemp_input_hrt")
unemp_input_hrt=b.get_number((1,792),1)

/*speed_input_hrt*/
sheets = b.set_sheet("speed_input_hrt")
speed_input_hrt=b.get_number((1,792),1)

/*inc_input_hrt*/
sheets = b.set_sheet("inc_input_hrt")
inc_input_hrt=b.get_number((1,792),1)

/*dens_input_hrt*/
sheets = b.set_sheet("dens_input_hrt")
dens_input_hrt=b.get_number((1,792),1)
end

/** mode_data data used in Mode choice.do*/
mata
/*Preliminaries*/
b.load_book("mode_data.xlsx")

/* coefforder*/
sheets = b.set_sheet("coefforder")
coefforder=b.get_number((1,2164),1)

/* varlookup*/
sheets = b.set_sheet("varlookup")
varlookup=b.get_number((1,2164),1)

/* regcode*/
sheets = b.set_sheet("regcode")
regcode=b.get_number((1,2164),1)

/* Modecode*/
sheets = b.set_sheet("Modecode")
Modecode=b.get_number((1,2164),1)

/* Mode*/
sheets = b.set_sheet("Mode")
Mode=b.get_number((1,2164),1)

/* ModeMatch*/
sheets = b.set_sheet("ModeMatch")
ModeMatch=b.get_number((1,2164),1)

/* varfull*/
sheets = b.set_sheet("varfull")
varfull=b.get_number((1,2164),1)

/* varcode*/
sheets = b.set_sheet("varcode")
varcode=b.get_number((1,2164),1)

/* coeff*/
sheets = b.set_sheet("coeff")
coeff=b.get_number((1,2164),1)

/* Map*/
sheets = b.set_sheet("Map")
Map=b.get_number((1,2164),1)

/* X*/
sheets = b.set_sheet("X")
X=b.get_number((1,2164),1)

/* Cost_indx*/
sheets = b.set_sheet("Cost_indx")
Cost_indx=b.get_number((1,6304),1)

/* cost_mode*/
sheets = b.set_sheet("cost_mode")
cost_mode=b.get_number((1,6304),1)

/* cost_modecode*/
sheets = b.set_sheet("cost_modecode")
cost_modecode=b.get_number((1,6304),1)

/* cost_reg*/
sheets = b.set_sheet("cost_reg")
cost_reg=b.get_number((1,6304),1)

/* cost_hh*/
sheets = b.set_sheet("cost_hh")
cost_hh=b.get_number((1,6304),1)

/* cost_yr*/
sheets = b.set_sheet("cost_yr")
cost_yr=b.get_number((1,6304),1)

/* ave_cost_perk*/
sheets = b.set_sheet("ave_cost_perk")
ave_cost_perk=b.get_number((1,6304),1)

/* modetime*/
sheets = b.set_sheet("modetime")
modetime=b.get_number((1,6304),1)

/* cost_perk*/
sheets = b.set_sheet("cost_perk")
cost_perk=b.get_number((1,88),(1,72))

/* mode_time*/
sheets = b.set_sheet("mode_time")
mode_time=b.get_number((1,88),(1,72))

/* peak*/
sheets = b.set_sheet("peak")
peak=b.get_number((1,88),(1,72))

/* logitmode*/
sheets = b.set_sheet("logitmode")
logitmode=b.get_number((1,2116),1)

/* logitreg*/
sheets = b.set_sheet("logitreg")
logitreg=b.get_number((1,2116),1)


/* logitcoeff*/
sheets = b.set_sheet("logitcoeff")
logitcoeff=b.get_number((1,2116),1)

/* logitmap*/
sheets = b.set_sheet("logitmap")
logitmap=b.get_number((1,2116),1)

/* fixed_reg*/
sheets = b.set_sheet("fixed_reg")
fixed_reg=b.get_number((1,12),1)

/* bus_fixed*/
sheets = b.set_sheet("bus_fixed")
bus_fixed=b.get_number((1,12),1)

/* cycle_fixed*/
sheets = b.set_sheet("cycle_fixed")
cycle_fixed=b.get_number((1,12),1)

/* drive_fixed*/
sheets = b.set_sheet("drive_fixed")
drive_fixed=b.get_number((1,12),1)

/* passenger_fixed*/
sheets = b.set_sheet("passenger_fixed")
passenger_fixed=b.get_number((1,12),1)

/* train_fixed*/
sheets = b.set_sheet("train_fixed")
train_fixed=b.get_number((1,12),1)

/* walk_fixed*/
sheets = b.set_sheet("walk_fixed")
walk_fixed=b.get_number((1,12),1)
end